////////////////////////////////////////////////////////////////////////////////
//
//  ****************************************************************************
//  * Project   : PEDump
//  * Unit Name : PropSheet.pas
//  * Purpose   :   
//  * Author    :  (Rouse_) 
//  * Copyright :  Fangorn Wizards Lab 1998 - 2006
//  * Version   : 1.00
//  * Home Page : http://rouse.front.ru
//  ****************************************************************************
//

//    , ,    :)

//  :

// Example Code for Implementation of the Property Sheet COM Object
// :  2005 Microsoft Corporation. (Platform SDK: Directory Services)
// http://windowssdk.msdn.microsoft.com/library/default.asp?url=/library/en-us/ad/ad/example_code_for_implementation_of_the_property_sheet_com_object.asp

unit PropSheet;

interface

uses
  Windows, Messages, ActiveX, ComObj, ShlObj, CommCtrl, UxTheme;

  //    (Yanis)
  //         
  //     ,   
  //  
  //      ...
  {$RANGECHECKS OFF}

type
  TFWPropertySheet = class(TComObject, IShellExtInit, IShellPropSheetExt)
  private
    hPSPage: HPropSheetPage;
  protected
    { IShellExtInit }
    function IShellExtInit.Initialize = SEIInitialize; 
    function SEIInitialize(pidlFolder: PItemIDList; lpdobj: IDataObject;
      hKeyProgID: HKEY): HResult; stdcall;
    { IShellPropSheetExt }
    function AddPages(lpfnAddPage: TFNAddPropSheetPage; lParam: LPARAM): HResult; stdcall;
    function ReplacePage(uPageID: UINT; lpfnReplaceWith: TFNAddPropSheetPage;
      lParam: LPARAM): HResult; stdcall;
  end;

  TFWPropertySheetFactory = class(TComObjectFactory)
  public
    procedure UpdateRegistry(Register: Boolean); override;
  end;

  TPropSheetPageEx = record
    dwSize: Longint;
    dwFlags: Longint;
    hInstance: THandle;
    case Integer of
      0: (
        pszTemplate: PAnsiChar);
      1: (
        pResource: Pointer;
    case Integer of
      0: (
        hIcon: THandle);
      1: (
        pszIcon: PAnsiChar;
    pszTitle: PAnsiChar;
    pfnDlgProc: Pointer;
    lParam: Longint;
    pfnCallback: TFNPSPCallbackA;
    pcRefParent: PInteger;
    pszHeaderTitle: PAnsiChar;
    pszHeaderSubTitle: PAnsiChar;
    hActCtx: THandle));
  end;

  function CreatePropertySheetPage(var PSP: TPropSheetPageEx): HPropSheetPage; stdcall;
    external comctl32 name 'CreatePropertySheetPageA';


var
  FileName: PChar;

implementation

uses
  SysUtils,ShellApi, ComServ, Types,
  DumpUtils, CommCtrlSupport,
  PEDumpConsts, HtmlHelp,
  ActivationCotext;

var
  TransparentBrush: HGDIOBJ;

//    
function PropertySheetDlgProc(hDlg: HWND; uMessage: UINT;
  wParam: WPARAM; lParam: LPARAM): LRESULT; stdcall;
const
  //   
  REDRAWWINDOWFLAGS = RDW_FRAME or RDW_INVALIDATE or RDW_ALLCHILDREN;
  TABPAGE_BODY = 10;
var
  Details: THANDLE;
  DlgRect, TVRect, LVRect, PSRect: TRect;
  LVHandle, TVHandle, StaticHandle: THandle;

  procedure GetControlRect(const Control: THandle; var Value: TRect);
  begin
    GetWindowRect(Control, Value);
    Value.Right := Value.Right - Value.Left;
    Value.Left := 0;
    Value.Bottom := Value.Bottom - Value.Top;
    Value.Top := 0;
  end;

begin
  case uMessage of

    //  
    WM_INITDIALOG:
    begin
      //  
      //InitHTMLHelp;
      //    , ..  
      //        
      // ,    (    )

      //        
      LVHandle := GetDlgItem(hDlg, IDC_LISTVIEW_EXPORT);
      TVHandle := GetDlgItem(hDlg, IDC_TREEVIEW_IMPORT);

      //      
      InitTreeViewImageList(TVHandle);
      GetImportTable(TVHandle, FileName);
      GetDelayImportTable(TVHandle, FileName);

      //      
      InitListView(LVHandle,  TVHandle);
      GetExportTable(LVHandle, FileName);

      //   
      GetControlRect(GetParent(hDlg), DlgRect);
      GetControlRect(hDlg, PSRect);
      GetControlRect(TVHandle, TVRect);
      GetControlRect(LVHandle, LVRect);
      if ListViewItemCount(LVHandle) = 0 then
      begin
        TVRect.Bottom := PSRect.Bottom - 40;
        SetWindowLong(LVHandle, GWL_STYLE,
          GetWindowLong(LVHandle, GWL_STYLE) and not WS_VISIBLE);
        SetWindowLong(LVHandle, GWL_STYLE,
          GetWindowLong(LVHandle, GWL_STYLE) and not WS_VISIBLE);
        StaticHandle := GetDlgItem(hDlg, IDC_EXPORT_LABEL);
        SetWindowLong(StaticHandle, GWL_STYLE,
          GetWindowLong(StaticHandle, GWL_STYLE) and not WS_VISIBLE);
      end
      else
        SetWindowPos(LVHandle, 0, 0, 0,
          DlgRect.Right - 46, LVRect.Bottom, SWP_NOMOVE or SWP_NOZORDER);
      SetWindowPos(TVHandle, 0, 0, 0,
        DlgRect.Right - 46, TVRect.Bottom, SWP_NOMOVE or SWP_NOZORDER);

      //   
      TransparentBrush := GetStockObject(NULL_BRUSH);
    end;

    //   
    WM_HELP:
    begin
      case PHelpInfo(LParam)^.iCtrlId of
        //    
        IDC_TREEVIEW_IMPORT:
          ShowContextHelpForImportList;

        //    
        IDC_LISTVIEW_EXPORT:
          ShowContextHelpForExportList;
      end;
      Result := 1;
      Exit;
    end;

    //    
    WM_CTLCOLORSTATIC:
    begin
      SetBkMode(WParam, TRANSPARENT);
      Result := TransparentBrush;
      Exit;
    end;

    //  
    WM_ERASEBKGND:
    // ,      
    if UseThemes then
    begin
      //   -  
      GetControlRect(hDlg, DlgRect);
      Details := OpenThemeData(hDlg, 'TAB');
      try
        DrawThemeBackground(Details, GetDC(hDlg), TABP_BODY, 0, DlgRect, nil);
      finally
        CloseThemeData(Details);
      end;
      //      
      RedrawWindow(hDlg, nil, 0, REDRAWWINDOWFLAGS);
      Result := 1;
      Exit;
    end;

    //  
    WM_DESTROY:
    begin
      //DeInitHTMLHelp;
      ReleaseTreeViewImageList(GetDlgItem(hDlg, IDC_TREEVIEW_IMPORT));
      FreeThemeLibrary;
      DeleteObject(TransparentBrush);
    end;

  end;
  Result := DefWindowProc(hDlg, uMessage, wParam, lParam);
end;

{ TFWPropertySheet }

function TFWPropertySheet.AddPages(lpfnAddPage: TFNAddPropSheetPage;
  lParam: LPARAM): HResult; stdcall;
const
  PSP_USEFUSIONCONTEXT = $00004000; 
var
  aPSPage: TPropSheetPage;
  aPSPageEx: TPropSheetPageEx;
  ManifestContext: DWORD;
begin
  InitThemeLibrary;
  ManifestContext := ActivateManifestContext;
  InitCommonControls;
  try      
    FillChar(aPSPage, SizeOf(TPropSheetPage), #0);
    aPSPage.dwSize      := SizeOf(TPropSheetPage);
    aPSPage.dwFlags     := PSP_USEREFPARENT or PSP_USETITLE or
                           PSP_DEFAULT or PSP_USEICONID or PSP_USECALLBACK or
                           PSP_USEFUSIONCONTEXT;
    aPSPage.hInstance   := HInstance;
    aPSPage.pszTemplate := MakeIntResource(IDD_FWPropertySheet);
    aPSPage.pszIcon     := MakeIntResource(ID_ICON);
    aPSPage.pszTitle    := ' /';
    aPSPage.pfnDlgProc  := @PropertySheetDlgProc;
    aPSPage.pcRefParent := @ComServer.ObjectCount;

    if ManifestContext <> INVALID_HANDLE_VALUE then
    begin
      Move(aPSPage, aPSPageEx, SizeOf(TPropSheetPage));
      aPSPageEx.hActCtx := ManifestContext;
      aPSPageEx.dwSize := SizeOf(TPropSheetPageEx);
      hPSPage := CreatePropertySheetPage(aPSPageEx);
    end
    else
      hPSPage := CommCtrl.CreatePropertySheetPage(aPSPage);

    if hPSPage <> nil then
    begin
      if(lpfnAddPage(hPSPage, lParam) = FALSE) then
      begin
        DestroyPropertySheetPage(hPSPage);
        Result := E_FAIL;
        Exit;
      end;
      Result := S_OK;
    end
    else
      Result := E_OUTOFMEMORY;
  finally
    DeActivateManifestContext;
  end;
end;

function TFWPropertySheet.ReplacePage(uPageID: UINT;
  lpfnReplaceWith: TFNAddPropSheetPage; lParam: LPARAM): HResult; stdcall;
begin
  Result := E_NOTIMPL;
end;

function TFWPropertySheet.SEIInitialize(pidlFolder: PItemIDList;
  lpdobj: IDataObject; hKeyProgID: HKEY): HResult; stdcall;
const
  ValidExt: array [0..6] of String[4] =
    ('.exe', '.dll', '.ocx', '.scr', '.cpl', '.tlb', '.olb');
var
  StgMedium: TStgMedium;
  FormatEtc: TFormatEtc;
  FilesCount, I: Integer;
  FileExt: String;
  IsValidExt: Boolean;
begin

  if (lpdobj = nil) then
  begin
    Result := E_INVALIDARG;
    Exit;
  end;

  with FormatEtc do begin
    cfFormat := CF_HDROP;
    ptd      := nil;
    dwAspect := DVASPECT_CONTENT;
    lindex   := -1;
    tymed    := TYMED_HGLOBAL;
  end;
  
  Result := lpdobj.GetData(FormatEtc, StgMedium);
  if Failed(Result) then Exit;
  try
    FilesCount := DragQueryFile(StgMedium.hGlobal, DWORD(-1), nil, 0);
    if FilesCount <> 1  then
      Result := E_FAIL
    else
    begin
      FileName := CoTaskMemAlloc(MAX_PATH);
      DragQueryFile(StgMedium.hGlobal, 0, FileName, MAX_PATH);
      FileExt := LowerCase(ExtractFileExt(String(FileName)));
      IsValidExt := False;
      for I := 0 to Length(ValidExt) - 1 do
        if ValidExt[I] = FileExt then
        begin
          IsValidExt := True;
          Break;
        end;
      if IsValidExt then
        Result := S_OK
      else
        Result := E_FAIL;
    end;
  finally
    ReleaseStgMedium(StgMedium);
  end;
end;

{ TFWPropertySheetFactory }

procedure TFWPropertySheetFactory.UpdateRegistry(Register: Boolean);
const
  szAppName = 'FWPropertySheet';
  szAppDescription = 'PEDump Property Page';
var
  szInProcServer32: String;
  szInProcServer32Root: String;
  szPropertySheetHandlers: String;
begin
  szPropertySheetHandlers := '*\shellex\PropertySheetHandlers\' + GUIDToString(ClassID);
  szInProcServer32Root := 'CLSID\' + GUIDToString(ClassID) + '\';
  szInProcServer32 := szInProcServer32Root + 'InProcServer32\';

  if Register then
  begin
    inherited UpdateRegistry(Register);
    CreateRegKey(szPropertySheetHandlers, '', szAppName);
    CreateRegKey(szInProcServer32Root, '', szAppDescription);
    if AnsiLowerCase(ExtractFileName(ParamStr(0))) = 'regsvr32.exe' then
      CreateRegKey(szInProcServer32, '', ParamStr(1))
    else
      if AnsiLowerCase(ExtractFileName(ParamStr(0))) = 'install.exe' then
        CreateRegKey(szInProcServer32, '',
          ExtractFilePath(ParamStr(0)) + 'PEDump.dll')
      else
        Abort;
    CreateRegKey(szInProcServer32, 'ThreadingModel', 'Apartment');
  end
  else
  begin
    DeleteRegKey(szInProcServer32);
    DeleteRegKey(szInProcServer32Root);
    inherited UpdateRegistry(Register);
  end;
end;

initialization
  TFWPropertySheetFactory.Create(ComServer, TFWPropertySheet,
    Class_FWPropertySheet, 'CharacterPage', '', ciMultiInstance, tmApartment);

finalization
  ReleaseActivateManifestContext;

end.
