////////////////////////////////////////////////////////////////////////////////
//
//  ****************************************************************************
//  * Project   : PEDump
//  * Unit Name : HtmlHelp.pas
//  * Purpose   :    
//  * Author    :  (Rouse_) 
//  * Copyright :  Fangorn Wizards Lab 1998 - 2006 .
//  * Version   : 1.00
//  * Home Page : http://rouse.front.ru
//  ****************************************************************************
//

unit HtmlHelp;

interface

uses
  Windows, Graphics, Types;

  //    (Yanis)
  //         
  //     ,   
  //  
  //      ...
  {$RANGECHECKS OFF}  

  procedure InitHTMLHelp;
  procedure DeInitHTMLHelp;
  procedure ShowContextHelpForExportList;
  procedure ShowContextHelpForImportList;

implementation

  { TODO : 
       HtmlHelpA ,
            .
      (
       5d324347     5d324347)
      .     ,
        : rouse79@yandex.ru }

type
  HH_POPUP = record
    cbStruct: Integer;
    hinst: THandle;
    idString: Cardinal;
    pszText: PChar;
    pt: TPoint;
    clrForeground: TColor;
    clrBackground: TColor;
    rcMargins: TRect;
    pszFont: PChar;
  end;

var
  hLibHandle: THandle = INVALID_HANDLE_VALUE;
  bLibLoaded: Boolean = False;
  HtmlHelpA: function(hwndCaller: HWND; pszFile: PAnsiChar;
    uCommand: UInt; dwData: DWORD): HWND; stdcall;

procedure InitHTMLHelp;
begin
  if hLibHandle <> INVALID_HANDLE_VALUE then Exit;
  HtmlHelpA := nil;
  hLibHandle := GetModuleHandle('hhctrl.ocx');
  if hLibHandle = 0 then
  begin
    hLibHandle := LoadLibrary('hhctrl.ocx');
    if hLibHandle <= HINSTANCE_ERROR then
    begin
      hLibHandle := INVALID_HANDLE_VALUE;
      Exit;
    end;
    bLibLoaded := True;
  end;
  HtmlHelpA := GetProcAddress(hLibHandle, 'HtmlHelpA');
end;

procedure DeInitHTMLHelp;
begin
  if bLibLoaded then
    FreeLibrary(hLibHandle);  
end;

procedure ShowHTMLHelp(const Data: String);
const
  HH_DISPLAY_TEXT_POPUP   = $000E;
var
  dwData: HH_POPUP;
  Pt: TPoint;
begin
  if not Assigned(HtmlHelpA) then Exit;
  GetCursorPos(Pt);
  ZeroMemory(@dwData, SizeOf(HH_POPUP));
  dwData.cbStruct := SizeOf(HH_POPUP);
  dwData.hinst := HInstance;
  dwData.pszText := PChar(Data);
  dwData.pt := Pt;
  dwData.clrForeground := clInfoText;
  dwData.clrBackground := ColorToRGB(clInfoBk);
  dwData.rcMargins := Rect(8, 8, 8, 10);
  dwData.pszFont := PChar('MS Sans Serif, 8');
  HtmlHelpA(0, nil, HH_DISPLAY_TEXT_POPUP, DWORD(@dwData));
end;

procedure ShowContextHelpForExportList;
resourcestring
  svHelp = '    ()   .';
begin
  ShowHTMLHelp(svHelp);
end;

procedure ShowContextHelpForImportList;
resourcestring
  svHelp = '    ()   . ' +
    '      . ' +
    '    DELAY_IMPORT  .';
begin
  ShowHTMLHelp(svHelp);
end;

end.
