////////////////////////////////////////////////////////////////////////////////
//
//  ****************************************************************************
//  * Project   : PEDump
//  * Unit Name : DumpUtils.pas
//  * Purpose   :     /  PE 
//  * Author    :  (Rouse_) 
//  * Copyright :  Fangorn Wizards Lab 1998 - 2006 .
//  * Version   : 1.00
//  * Home Page : http://rouse.front.ru
//  ****************************************************************************
//

unit DumpUtils;

interface

//  :

// Peering Inside the PE: A Tour of the Win32 Portable Executable File Format
// : Matt Pietrek
// http://msdn.microsoft.com/library/default.asp?url=/library/en-us/dndebug/html/msdn_peeringpe.asp

// An In-Depth Look into the Win32 Portable Executable File Format, Part 2
// : Matt Pietrek
// http://msdn.microsoft.com/msdnmag/issues/02/03/PE2/default.aspx

  //    (Yanis)
  //         
  //     ,   
  //  
  //      ...
  {$RANGECHECKS OFF}

uses
  Windows,
  SysUtils,
  DebugHlp;

  procedure GetImportTable(const TreeView: THandle; const PEFile: String);
  procedure GetDelayImportTable(const TreeView: THandle; const PEFile: String);
  procedure GetExportTable(const ListView: THandle; const PEFile: String);

implementation

uses
  CommCtrlSupport;

{$I import.inc}

type
  TFWOrdinalData = record
    FuncName: ShortString;
    Ordinal: DWORD;
    Addr: String[10];
  end;
  TFWOrdinalDataArray = array of TFWOrdinalData;

var
  OrdinalData: TFWOrdinalDataArray;

procedure MapAndLoadModuleForReadOrdinalFuncName(const ModuleName: String);
type
  PDWORDArray = ^TDWORDArray;
  TDWORDArray = array [0..MaxInt div SizeOf(DWORD) - 1] of DWORD;
var
  liImageInfo: LoadedImage;
  pExportDirectory: PImageExportDirectory;
  nDirSize: Cardinal;
  pDummy: PImageSectionHeader;
  I: Cardinal;
  pNameRVAs: PDWORDArray;
  FuncName, FuncAddr: String;
  Ordinal: PWORD;
begin
  SetLength(OrdinalData, 0);
  if MapAndLoad(PChar(ModuleName), nil, @liImageInfo, True, True) then
  begin
    try
      //      (.   Readme.txt)
      pExportDirectory := ImageDirectoryEntryToData(liImageInfo.MappedAddress,
        False, IMAGE_DIRECTORY_ENTRY_EXPORT, nDirSize);
      if (pExportDirectory <> nil) then
      begin
        //      .
        pDummy := nil;
        pNameRVAs := ImageRvaToVa(liImageInfo.FileHeader,
          liImageInfo.MappedAddress,
          DWORD(pExportDirectory^.AddressOfNames), pDummy);
        pDummy := nil;
        Ordinal := ImageRvaToVa(liImageInfo.FileHeader,
          liImageInfo.MappedAddress,
          DWORD(pExportDirectory^.AddressOfNameOrdinals), pDummy);
        //   ,    ...
        for I := 0 to pExportDirectory^.NumberOfNames - 1 do
        begin
          SetLength(OrdinalData, Length(OrdinalData) + 1);
          //   
          pDummy := nil;
          FuncName := PChar(ImageRvaToVa(liImageInfo.FileHeader,
            liImageInfo.MappedAddress, pNameRVAs^[i], pDummy));
          FuncAddr := PChar('0x' + IntToHex(Integer(pNameRVAs^[I]), 8));
          //   
          OrdinalData[Length(OrdinalData) - 1].FuncName := FuncName;
          OrdinalData[Length(OrdinalData) - 1].Addr := FuncAddr;
          OrdinalData[Length(OrdinalData) - 1].Ordinal := Ordinal^ + pExportDirectory^.Base;
          Inc(Ordinal);
        end;
      end;
    finally
      //  
      UnMapAndLoad(@liImageInfo);
    end;
  end;
end;

function ReadOrdinalFuncName(const Ordinal: DWORD): String;
var
  I: Integer;
begin
  Result := '';
  for I := 0 to Length(OrdinalData) - 1 do
    if OrdinalData[I].Ordinal = Ordinal then
    begin
      Result := OrdinalData[I].FuncName;
      Break;
    end;
end;

function ReadOrdinalFuncAddr(const Ordinal: DWORD): String;
var
  I: Integer;
begin
  Result := '';
  for I := 0 to Length(OrdinalData) - 1 do
    if OrdinalData[I].Ordinal = Ordinal then
    begin
      Result := OrdinalData[I].Addr;
      Break;
    end;
end;

//   
procedure GetImportTable(const TreeView: THandle; const PEFile: String);
var
  ImageInfo: LOADED_IMAGE;
  DirSize: Cardinal;
  pDummy: PImageSectionHeader;
  Image: PIMAGE_IMPORT_DESCRIPTOR;
  ModuleName, FuncName, FuncAddr: PChar;
  Thunk: PImageThunkData32;
  IsOrd: Boolean;
begin
  BeginUpdate(TreeView);
  try
    if MapAndLoad(PChar(PEFile), nil, @ImageInfo, True, True) then
    begin
      try
        //     
        Image := ImageDirectoryEntryToData(ImageInfo.MappedAddress,
          False, IMAGE_DIRECTORY_ENTRY_IMPORT, DirSize);
        if (Image <> nil) then
        begin
          //    
          while Image^.Name <> 0 do
          begin
            pDummy := nil;
            //   
            ModuleName := ImageRvaToVa(ImageInfo.FileHeader,
              ImageInfo.MappedAddress, Image^.Name, pDummy);
            AddTreeViewNode(TreeView, ModuleName, '', True, False, False);

            //   
            if Image^.Union.OriginalFirstThunk <> nil then
              // OriginalFirstThunk -     
              //    Delphi&C++ Bilder
              Thunk := PImageThunkData32(ImageRvaToVa(ImageInfo.FileHeader,
                ImageInfo.MappedAddress, Image^.Union.Characteristics, pDummy))
            else
              //  OriginalFirstThunk  -     
              Thunk := PImageThunkData32(ImageRvaToVa(ImageInfo.FileHeader,
                ImageInfo.MappedAddress, DWORD(Image^.FirstThunk), pDummy));

            if Thunk <> nil then
            try
              while Thunk^.Function_ <> nil do
              begin
                //     ,  
                //    
                //       
                if (DWORD(Thunk^.Function_) and IMAGE_ORDINAL_FLAG) = IMAGE_ORDINAL_FLAG then
                begin
                  if Length(OrdinalData) = 0 then
                    MapAndLoadModuleForReadOrdinalFuncName(ModuleName);
                  FuncName := PChar(ReadOrdinalFuncName(DWORD(Thunk^.Function_) and $FFFF));
                  if Length(FuncName) = 0 then
                  begin
                    FuncName := PChar(ModuleName + ': ' +
                      InttoStr(DWORD(Thunk^.Function_) and $FFFF));
                    FuncAddr := Pchar('Ord ' + InttoStr(DWORD(Thunk^.Function_) and $FFFF));
                  end
                  else
                    FuncAddr := Pchar(ReadOrdinalFuncAddr(DWORD(Thunk^.Function_) and $FFFF));
                  IsOrd := True;
                end
                else
                begin
                  //     -     
                  FuncName := PImageImportByName(ImageRvaToVa(ImageInfo.FileHeader,
                    ImageInfo.MappedAddress, DWORD(Thunk^.AddressOfData), pDummy)).Name;
                  FuncAddr := PChar('0x' + IntToHex(DWORD(Thunk^.AddressOfData), 8));
                  IsOrd := False;
                end;

                AddTreeViewNode(TreeView, ModuleName,
                  Format('%-30s %s', [FuncName, FuncAddr]), False, False, IsOrd);
                Inc(Thunk);
              end;
              Inc(Image);
            finally
              SetLength(OrdinalData, 0);
            end;
          end;
        end;
      finally
        UnMapAndLoad(@ImageInfo);
      end;
    end;
  finally
    EndUpdate(TreeView);
  end;
end;

//    
//  GetImportTable,      
procedure GetDelayImportTable(const TreeView: THandle; const PEFile: String);
var
  ImageInfo: LOADED_IMAGE;
  DirSize: Cardinal;
  Image: PImgDelayDescr;
  ModuleName, FuncName, FuncAddr: PChar;
  Thunk: PImageThunkData32;
  IsOrd: Boolean;

  function RvaToVaWithAmendment(Value: DWORD): Pointer;
  var
    pDummy: PImageSectionHeader;
  begin
    if (Value > ImageInfo.SizeOfImage) and
      (Value > ImageInfo.FileHeader^.OptionalHeader.ImageBase) then
      Dec(Value, ImageInfo.FileHeader^.OptionalHeader.ImageBase);
    pDummy := nil;
    Result := ImageRvaToVa(ImageInfo.FileHeader, ImageInfo.MappedAddress,
      Value, pDummy);
  end;

begin
  BeginUpdate(TreeView);
  try
    if MapAndLoad(PChar(PEFile), nil, @ImageInfo, True, True) then
    begin
      try
        Image := ImageDirectoryEntryToData(ImageInfo.MappedAddress,
          False, IMAGE_DIRECTORY_ENTRY_DELAY_IMPORT, DirSize);
        if (Image <> nil) then
        begin
          while Image^.szName <> 0 do
          begin
            ModuleName := RvaToVaWithAmendment(DWORD(Image^.szName));
            AddTreeViewNode(TreeView, ModuleName, '', True, True, False);
            Thunk := PImageThunkData32(RvaToVaWithAmendment(DWORD(Image^.pINT.AddressOfData)));
            if Thunk <> nil then
            try
              while Thunk^.Function_ <> nil do
              begin
                if (DWORD(Thunk^.Function_) and IMAGE_ORDINAL_FLAG) = IMAGE_ORDINAL_FLAG then
                begin
                  if Length(OrdinalData) = 0 then
                    MapAndLoadModuleForReadOrdinalFuncName(ModuleName);
                  FuncName := PChar(ReadOrdinalFuncName(DWORD(Thunk^.Function_) and $FFFF));
                  if Length(FuncName) = 0 then
                  begin
                    FuncName := PChar(ModuleName + ': ' +
                      InttoStr(DWORD(Thunk^.Function_) and $FFFF));
                    FuncAddr := Pchar('Ord ' + InttoStr(DWORD(Thunk^.Function_) and $FFFF));
                  end
                  else
                    FuncAddr := Pchar(ReadOrdinalFuncAddr(DWORD(Thunk^.Function_) and $FFFF));
                  IsOrd := True;
                end
                else
                begin
                  FuncName := PImageImportByName(RvaToVaWithAmendment(DWORD(Thunk^.AddressOfData))).Name;
                  FuncAddr := PChar('0x' + IntToHex(DWORD(Thunk^.AddressOfData), 8));
                  IsOrd := False;
                end;
                AddTreeViewNode(TreeView, ModuleName,
                  Format('%-30s %s', [FuncName, FuncAddr]), False, True, IsOrd);
                Inc(Thunk);
              end;
            Inc(Image);
            finally
              SetLength(OrdinalData, 0);
            end;
          end;
        end;
      finally
        UnMapAndLoad(@ImageInfo);
      end;
    end;
  finally
    EndUpdate(TreeView);
  end;
end;

//   ...
procedure GetExportTable(const ListView: THandle; const PEFile: String);
type
  PDWORDArray = ^TDWORDArray;
  TDWORDArray = array [0..MaxInt div SizeOf(DWORD) - 1] of DWORD;
var
  liImageInfo: LoadedImage;
  pExportDirectory: PImageExportDirectory;
  nDirSize: Cardinal;
  pDummy: PImageSectionHeader;
  I: Integer;
  pNameRVAs: PDWORDArray;
  FuncName, FuncAddr: String;
begin
  //  
  BeginUpdate(ListView);
  try
    if MapAndLoad(PChar(PEFile), nil, @liImageInfo, True, True) then
    begin
      try
        //     
        pExportDirectory := ImageDirectoryEntryToData(liImageInfo.MappedAddress,
          False, IMAGE_DIRECTORY_ENTRY_EXPORT, nDirSize);
        if (pExportDirectory <> nil) then
        begin
          //      .
          pDummy := nil;
          pNameRVAs := ImageRvaToVa(liImageInfo.FileHeader,
            liImageInfo.MappedAddress,
            DWORD(pExportDirectory^.AddressOfNames), pDummy);
          //   ,    ...
          for I := 0 to pExportDirectory^.NumberOfNames - 1 do
          begin
            //   
            pDummy := nil;
            FuncName := PChar(ImageRvaToVa(liImageInfo.FileHeader,
              liImageInfo.MappedAddress, pNameRVAs^[i], pDummy));
            FuncAddr := PChar('0x' + IntToHex(Integer(pNameRVAs^[I]), 8));
            //   
            AddListViewRow(ListView, FuncName, FuncAddr);
          end;
        end;
      finally
        //  
        UnMapAndLoad(@liImageInfo);
      end;
    end;
  finally
    EndUpdate(ListView);
  end;
end;

end.
