////////////////////////////////////////////////////////////////////////////////
//
//  ****************************************************************************
//  * Project   : PEDump
//  * Unit Name : DebugHlp.pas
//  * Purpose   :   ImageHlpAPI   
//                  Windows 98/ME
//  * Author    :  (Rouse_) 
//  * Copyright :  Fangorn Wizards Lab 1998 - 2006 .
//  * Version   : 1.00
//  * Home Page : http://rouse.front.ru
//  ****************************************************************************
//

unit DebugHlp;

interface

  //    (Yanis)
  //         
  //     ,   
  //  
  //      ...
  {$RANGECHECKS OFF}

uses
  Windows;

  //  :
  // Peering Inside the PE: A Tour of the Win32 Portable Executable File Format
  // : Matt Pietrek
  // http://msdn.microsoft.com/library/default.asp?url=/library/en-us/dndebug/html/msdn_peeringpe.asp

  // An In-Depth Look into the Win32 Portable Executable File Format, Part 2
  // : Matt Pietrek
  // http://msdn.microsoft.com/msdnmag/issues/02/03/PE2/default.aspx

{$I import.inc}

  function MapAndLoad(ImageName, DllPath: LPSTR; LoadedImage: PLoadedImage;
    DotDll, ReadOnly: Bool): Bool; stdcall; external 'Imagehlp.dll';

  function UnMapAndLoad(LoadedImage: PLoadedImage): Bool; stdcall;
    external 'Imagehlp.dll';

  function ImageRvaToVa(NtHeaders: PImageNtHeaders; Base: Pointer;
    Rva: ULONG; var LastRvaSection: PImageSectionHeader): Pointer;

  function ImageDirectoryEntryToData(Base: Pointer; MappedAsImage: ByteBool;
    DirectoryEntry: Word; var Size: ULONG): Pointer;

implementation

function FieldOffset(const Struc; const Field): Cardinal;
begin
  Result := Cardinal(@Field) - Cardinal(@Struc);
end;

function IMAGE_FIRST_SECTION(NtHeader: PImageNtHeaders): PImageSectionHeader;
begin
  Result := PImageSectionHeader(Cardinal(NtHeader) +
    FieldOffset(NtHeader^, NtHeader^.OptionalHeader) +
    NtHeader^.FileHeader.SizeOfOptionalHeader);
end;

function ImageRvaToSection(NtHeaders: PImageNtHeaders; Base: Pointer;
  Rva: ULONG): PImageSectionHeader;
var
  NtSection: PImageSectionHeader;
  I: Integer;
begin
  Result := nil;
  NtSection := IMAGE_FIRST_SECTION(NtHeaders);
  for I := 0 to NtHeaders^.FileHeader.NumberOfSections - 1 do
    if (Rva >= NtSection.VirtualAddress) and
      (Rva < NtSection.VirtualAddress + NtSection.SizeOfRawData) then
    begin
      Result := NtSection;
      Exit;
    end
    else
      Inc(NtSection);
end;

function ImageRvaToVa(NtHeaders: PImageNtHeaders; Base: Pointer;
  Rva: ULONG; var LastRvaSection: PImageSectionHeader): Pointer;
var
  NtSection: PImageSectionHeader;
begin
  Result := nil;
  NtSection := LastRvaSection;
  if (LastRvaSection = nil) or (Rva < NtSection^.VirtualAddress) or
    (Rva < NtSection^.VirtualAddress + NtSection^.SizeOfRawData) then
    NtSection := ImageRvaToSection(NtHeaders, Base, Rva);
  if NtSection = nil then Exit;
  if LastRvaSection <> nil then
    LastRvaSection := NtSection;
  Result := Pointer(DWORD(Base) + (Rva - NtSection^.VirtualAddress) +
    NtSection^.PointerToRawData);
end;


//   ImageDirectoryEntryToData
//      :
//    OptionalHeader->Magic == IMAGE_NT_OPTIONAL_HDR64_MAGIC
//    OptionalHeader->Magic == IMAGE_ROM_OPTIONAL_HDR_MAGIC
function ImageDirectoryEntryToData(Base: Pointer; MappedAsImage: ByteBool;
  DirectoryEntry: Word; var Size: ULONG): Pointer;
const
  IMAGE_NT_OPTIONAL_HDR32_MAGIC = $10B;
  IMAGE_NT_OPTIONAL_HDR64_MAGIC = $20B;
  IMAGE_ROM_OPTIONAL_HDR_MAGIC  = $107;
var
  DOSHeader: PImageDosHeader;
  NTHeader: PImageNtHeaders;
  FileHeader: TImageFileHeader;
  NtSection: PImageSectionHeader;
  OptionalHeader: TImageOptionalHeader;
  DirectoryAddress: DWORD;
  I: Integer;
begin
  Result := nil;

  if (DWORD(Base) and 1) = 1 then
    Base := Pointer((DWORD(Base) and not 1));

  DOSHeader := PImageDosHeader(Base);
  if IsBadReadPtr(Pointer(Base), SizeOf(TImageNtHeaders)) then Exit;
  if (DOSHeader^.e_magic <> IMAGE_DOS_SIGNATURE) then Exit;
  NTHeader := PImageNtHeaders(DWORD(DOSHeader) + DWORD(DOSHeader^._lfanew));
  if NTHeader^.Signature <> IMAGE_NT_SIGNATURE then Exit;
  FileHeader := NTHeader^.FileHeader;
  if FileHeader.Machine <> IMAGE_FILE_MACHINE_I386 then Exit;
  OptionalHeader := NTHeader^.OptionalHeader;
  if OptionalHeader.Magic <> IMAGE_NT_OPTIONAL_HDR32_MAGIC then Exit;
  
  if DirectoryEntry >= OptionalHeader.NumberOfRvaAndSizes then
  begin
    Size := 0;
    Exit;
  end;

  DirectoryAddress :=
    OptionalHeader.DataDirectory[DirectoryEntry].VirtualAddress;
  if DirectoryAddress = 0 then
  begin
    Size := 0;
    Exit;
  end;

  Size := OptionalHeader.DataDirectory[DirectoryEntry].Size;
  if MappedAsImage and (DirectoryAddress < OptionalHeader.SizeOfHeaders) then
  begin
    Result := Pointer(DWORD(Base) + DirectoryAddress);
    Exit;
  end;   

  NtSection := ImageRvaToSection(NTHeader, Base, DirectoryAddress);
  if NtSection = nil then 
  begin
    Size := 0;
    Exit;
  end;

  for I := 0 to FileHeader.NumberOfSections - 1 do
    if (DirectoryAddress >= NtSection^.VirtualAddress) and
      (DirectoryAddress < NtSection^.VirtualAddress + NtSection^.SizeOfRawData) then
    begin
      Result := Pointer(DWORD(Base) +
        (DirectoryAddress - NtSection^.VirtualAddress) + NtSection^.PointerToRawData);
      Break;
    end
    else
      Inc(NtSection);
end;

end.
