////////////////////////////////////////////////////////////////////////////////
//
//  ****************************************************************************
//  * Project   : PEDump
//  * Unit Name : CommCtrlSupport.pas
//  * Purpose   :      ListView  TreeView
//  * Author    :  (Rouse_) 
//  * Copyright :  Fangorn Wizards Lab 1998 - 2006 .
//  * Version   : 1.00
//  * Home Page : http://rouse.front.ru
//  ****************************************************************************
//

unit CommCtrlSupport;

interface

  //  :

  // Tree-View Control Reference
  // http://msdn.microsoft.com/library/default.asp?url=/library/en-us/shellcc/platform/commctls/treeview/reflist.asp

  // List-View Control Reference
  // http://msdn.microsoft.com/library/default.asp?url=/library/en-us/shellcc/platform/commctls/listview/reflist.asp


  //    (Yanis)
  //         
  //     ,   
  //  
  //      ...
  {$RANGECHECKS OFF}  

uses
  Windows,
  Messages,
  CommCtrl;

  procedure InitTreeViewImageList(const TreeViewHandle: THandle);
  procedure InitListView(const ListViewHandle, TreeViewHandle: THandle);
  procedure ReleaseTreeViewImageList(const TreeViewHandle: THandle);
  procedure AddListViewRow(const ListViewHandle: THandle;
    const FuncName, FuncAddr: String);
  procedure AddTreeViewNode(const TreeViewHandle: THandle;
    const ModuleName, FuncName: String; const Root, Delay, Ordinal: Boolean);
  function ListViewItemCount(const ListViewHandle: THandle): Integer;
  procedure BeginUpdate(Control: THandle);
  procedure EndUpdate(Control: THandle);

implementation

uses SysUtils, PEDumpConsts;

type
  TTVItemData = record
    ItemName: String;
    Handle: HTREEITEM;
  end;

  TTVItems = record
    Items: array of TTVItemData;
    Count: Integer;
  end;

var
  TVItems: TTVItems;

//  ImageList   
procedure InitTreeViewImageList(const TreeViewHandle: THandle);
var
  ImageList: THandle;
begin
  //  ImageList
  ImageList := ImageList_Create(16, 16, ILC_MASK or ILC_COLOR32, 0, 0);
  //   
  ImageList_SetBkColor(ImageList, $FFFFFFFF);
  //   
  ImageList_AddIcon(ImageList, LoadIcon(HInstance, MakeIntResource(ICO_IMPORT_DLL)));
  ImageList_AddIcon(ImageList, LoadIcon(HInstance, MakeIntResource(ICO_FUNCTION)));
  ImageList_AddIcon(ImageList, LoadIcon(HInstance, MakeIntResource(ICO_DELAY_FUNCTION)));
  //  ImageList  
  TreeView_SetImageList(TreeViewHandle, ImageList, TVSIL_NORMAL);
end;

//   
procedure InitListView(const ListViewHandle, TreeViewHandle: THandle);
const
  ColumnCaption: array [0..1] of PChar = (' :', ':');
var
  lvColumn: TLVColumn;
  ImageList: THandle;
begin
  //     
  ZeroMemory(@lvColumn, SizeOf(TLVColumn));
  lvColumn.mask := LVCF_FMT or LVCF_WIDTH or LVCF_TEXT or LVCF_SUBITEM;
  lvColumn.fmt := LVCFMT_LEFT;
  lvColumn.cx := 245;
  lvColumn.pszText := PChar(ColumnCaption[0]);
  lvColumn.cchTextMax := Length(lvColumn.pszText) + 1;
  //   
  ListView_InsertColumn(ListViewHandle, 0, lvColumn);
  lvColumn.cx := 100;
  lvColumn.pszText := PChar(ColumnCaption[1]);
  lvColumn.cchTextMax := Length(lvColumn.pszText) + 1;
  //   
  ListView_InsertColumn(ListViewHandle, 1, lvColumn);
  //      
  ListView_SetExtendedListViewStyle(ListViewHandle, LVS_EX_FULLROWSELECT);
  //   ImageList-   
  ImageList := TreeView_GetImageList(TreeViewHandle, TVSIL_NORMAL);
  //   ImageList   
  ListView_SetImageList(ListViewHandle, ImageList, LVSIL_SMALL)
end;

//  ImageList    
procedure ReleaseTreeViewImageList(const TreeViewHandle: THandle);
var
  ImageList: THandle;
begin
  //  
  ImageList := TreeView_GetImageList(TreeViewHandle, TVSIL_NORMAL);
  // 
  ImageList_Destroy(ImageList);
end;

//      
procedure AddListViewRow(const ListViewHandle: THandle;
  const FuncName, FuncAddr: String);
var
  lvItem: TLVItem;
  nvItemIndex: Integer;
begin
  //       
  nvItemIndex := ListView_GetItemCount(ListViewHandle);
  ZeroMemory(@lvItem, SizeOf(TLVItem));
  lvItem.iItem := nvItemIndex;
  lvItem.mask := LVIF_TEXT or LVIF_IMAGE;
  lvItem.pszText := PChar(FuncName);
  lvItem.cchTextMax := Length(FuncName) + 1;
  lvItem.iImage := 1;
  //   
  ListView_InsertItem(ListViewHandle, lvItem);
  lvItem.mask := LVIF_TEXT;
  lvItem.iSubItem := 1;
  lvItem.pszText := PChar(FuncAddr);
  lvItem.cchTextMax := Length(FuncAddr) + 1;
  //     
  ListView_SetItem(ListViewHandle, lvItem);
end;

//      
procedure AddTreeViewNode(const TreeViewHandle: THandle;
  const ModuleName, FuncName: String; const Root, Delay, Ordinal: Boolean);

  //     
  function GetRootHandle(const Value: String): HTREEITEM;
  var
    I: Integer;
  begin
    Result := nil;
    for I := 0 to TVItems.Count - 1 do
      if TVItems.Items[I].ItemName = AnsiUpperCase(Value) then
      begin
        Result := TVItems.Items[I].Handle;
        Break;
      end;
  end;

var
  tvItem: TTVInsertStruct;
  cRootHandle: HTREEITEM;
begin
  //       
  ZeroMemory(@tvItem, SizeOf(TTVInsertStruct));
  tvItem.hInsertAfter := TVI_LAST;
  tvItem.item.mask := TVIF_TEXT or TVIF_STATE or TVIF_IMAGE or TVIF_SELECTEDIMAGE;
  if Root then
  begin
    //   
    cRootHandle := GetRootHandle(ModuleName);
    if cRootHandle <> nil then Exit;
    tvItem.hParent := TVI_ROOT;
    tvItem.item.stateMask := $FFFFFFFF;
    if Delay then
      tvItem.item.state := TVIS_BOLD;

    tvItem.item.pszText := PChar(AnsiUpperCase(ModuleName));
    tvItem.item.cchTextMax := Length(ModuleName) + 1;
    cRootHandle := TreeView_InsertItem(TreeViewHandle, tvItem);
    if cRootHandle <> nil then
    begin
      Inc(TVItems.Count);
      SetLength(TVItems.Items, TVItems.Count);
      TVItems.Items[TVItems.Count - 1].ItemName := AnsiUpperCase(ModuleName);
      TVItems.Items[TVItems.Count - 1].Handle := cRootHandle;
    end;
  end
  else
  begin
    //   
    cRootHandle := GetRootHandle(ModuleName);
    if cRootHandle = nil then Exit;
    tvItem.hParent := cRootHandle;
    tvItem.item.iImage := 1 + Integer(Ordinal);
    tvItem.item.iSelectedImage := 1 + Integer(Ordinal);
    tvItem.item.pszText := PChar(FuncName);
    tvItem.item.cchTextMax := Length(FuncName) + 1;
    TreeView_InsertItem(TreeViewHandle, tvItem);
  end;
end;

//   

procedure BeginEndUpdate(Control: THandle; Updating: Boolean);
begin
  SendMessage(Control, WM_SETREDRAW, Ord(not Updating), 0);
end;

procedure BeginUpdate(Control: THandle);
begin
  BeginEndUpdate(Control, True);
end;

procedure EndUpdate(Control: THandle);
begin
  BeginEndUpdate(Control, False);
end;

function ListViewItemCount(const ListViewHandle: THandle): Integer;
begin
  Result := ListView_GetItemCount(ListViewHandle);
end;

end.


