////////////////////////////////////////////////////////////////////////////////
//
//  ****************************************************************************
//  * Project   : PEDump
//  * Unit Name : ActivationCotext.pas
//  * Purpose   :   
//                   
//  * Author    :  (Rouse_) 
//  * Copyright :  Fangorn Wizards Lab 1998 - 2006
//  * Version   : 1.00
//  * Home Page : http://rouse.front.ru
//  ****************************************************************************
//

unit ActivationCotext;

interface

  //  :

  // Using the Activation Context API
  // http://msdn.microsoft.com/library/default.asp?url=/library/en-us/sbscs/setup/using_the_activation_context_api.asp

uses
  Windows,
  PEDumpConsts, SysUtils;

  function ActivateManifestContext: DWORD;
  procedure DeActivateManifestContext;
  procedure ReleaseActivateManifestContext;

implementation

type
  TActCTXA = packed record
    cbSize: ULONG;
    dwFlags: DWORD;
    lpSource: LPCSTR;
    wProcessorArchitecture: WORD;
    wLangId: LANGID;
    lpAssemblyDirectory: LPCSTR;
    lpResourceName: LPCSTR;
    lpApplicationName: LPCSTR;
    hModule: HMODULE;
  end;

var
  ActivateActCtx:   function(hActCtx: THandle; var lpCookie: Pointer): BOOL; stdcall;
  CreateActCtxA:    function(var pActCtx: TActCTXA): THandle; stdcall;
  DeactivateActCtx: function(hActCtx: THandle; lpCookie: Pointer): BOOL; stdcall;
  ReleaseActCtx:    procedure(hActCtx: THandle); stdcall;

var
  hContext: THandle = INVALID_HANDLE_VALUE;
  pCookie: Pointer = nil;

function ActivateManifestContext: DWORD;
var
  KernelHandle: THandle;
  ActCTXA : TActCTXA;
  Buffer: array[0..MAX_PATH - 1] of Char;
begin
  Result := INVALID_HANDLE_VALUE;
  try
    KernelHandle := GetModuleHandle(PChar(kernel32));
    if KernelHandle > HINSTANCE_ERROR then
    begin
      ActivateActCtx := GetProcAddress(KernelHandle, PChar('ActivateActCtx'));
      if not Assigned(ActivateActCtx) then Exit;
      CreateActCtxA := GetProcAddress(KernelHandle, PChar('CreateActCtxA'));
      if not Assigned(CreateActCtxA) then Exit;
      DeactivateActCtx := GetProcAddress(KernelHandle, PChar('DeactivateActCtx'));
      if not Assigned(DeactivateActCtx) then Exit;
      ReleaseActCtx := GetProcAddress(KernelHandle, PChar('ReleaseActCtx'));
      if not Assigned(ReleaseActCtx) then Exit;
    end;
    ZeroMemory(@ActCTXA, SizeOf(TActCTXA));
    ActCTXA.cbSize := SizeOf(TActCTXA);
    ActCTXA.dwFlags := ACTCTX_FLAG_RESOURCE_NAME_VALID;
    GetModuleFileName(hInstance, Buffer, MAX_PATH);
    ActCTXA.lpSource := Buffer;
    ActCTXA.lpResourceName :=
      MAKEINTRESOURCE(ISOLATIONAWARE_MANIFEST_RESOURCE_ID);
    hContext := CreateActCtxA(ActCTXA);
    if hContext = INVALID_HANDLE_VALUE then Exit;
    pCookie := nil;
    if ActivateActCtx(hContext, pCookie) then
      Result := hContext;
  except
    Result := INVALID_HANDLE_VALUE;
    MessageBox(0, 'ActivateManifestContext failed', '', MB_OK or MB_ICONERROR);
  end;
end;

procedure DeActivateManifestContext;
begin
  if not Assigned(DeactivateActCtx) then Exit;
  try
    DeactivateActCtx(0, pCookie);
  except
    MessageBox(0, pchar(SysErrorMessage(GetLastError)), 'DeActivateManifestContext failed', MB_OK or MB_ICONERROR);
  end;
end;

procedure ReleaseActivateManifestContext;
begin
  if not Assigned(ReleaseActCtx) then Exit;
  try
    ReleaseActCtx(hContext);
  except
    MessageBox(0, pchar(SysErrorMessage(GetLastError)), 'ReleaseActivateManifestContext failed', MB_OK or MB_ICONERROR);
  end;
end;

end.
