////////////////////////////////////////////////////////////////////////////////
//
//  ****************************************************************************
//  * Project   : PEDump
//  * Unit Name : Install.dpr
//  * Purpose   :    
//  * Author    :  (Rouse_) 
//  * Copyright :  Fangorn Wizards Lab 1998 - 2006 .
//  * Version   : 1.00
//  * Home Page : http://rouse.front.ru
//  ****************************************************************************
//

program Install;

{$APPTYPE CONSOLE}

uses
  Windows,
  SysUtils;

const
  PEDump = 'PEDump.dll';

  function DllRegisterServer: HResult; stdcall; external PEDump;
  function DllUnregisterServer: HResult; stdcall; external PEDump;

const
  sLineBreak = #13#10;

  function Translate(Value: String): String;
  begin
    SetLength(Result, Length(Value));
    AnsiToOem(@Value[1], @Result[1]);
  end;

  procedure ShowHelp;
  resourcestring
    HELP_MESSAGE = '   .' + sLineBreak +
      ':  (Rouse_) ' + sLineBreak +
      '=====================================================' + sLineBreak +
      '  :' + sLineBreak +
      '  install.exe -i [ ]' + sLineBreak +
      '  install.exe -u [   ]';
  begin
    Writeln(Translate(HELP_MESSAGE));
  end;

  function WaitKeyboardInput(Promt: String): Char;
  var
    Done: Boolean;
    IR: INPUT_RECORD;
    hCon: THandle;
    NumOfEvents,
    NumOfEventsRead: DWORD;
    I: Integer;
  begin
    Writeln;
    Writeln(Translate(Promt));

    Result := #0;
    Done := False;
    hCon := GetStdHandle(STD_INPUT_HANDLE);
    try
      while not Done do
      begin

         if not GetNumberOfConsoleInputEvents(hCon, NumOfEvents) then
           raise EInOutError.CreateFmt(
            'GetNumberOfConsoleInputEvents failed %s',
            [SysErrorMessage(GetLastError)]);

         for I := 0 to NumOfEvents - 1 do
         begin
           if (not ReadConsoleInput(hCon, ir, 1, NumOfEventsRead)) then
             raise EInOutError.CreateFmt(
              'ReadConsoleInput failed %s', [SysErrorMessage(GetLastError)]);

           Done :=
             (NumOfEventsRead = 1) and
             (IR.EventType = KEY_EVENT) and
             TKeyEventRecord(IR.Event).bKeyDown;

           if Done then
             Result := TKeyEventRecord(IR.Event).AsciiChar;
         end;
      end;
    except
      on E : Exception do
       Writeln(Format('Exception: %s', [E.Message]));
    end;
  end;

  function InstallShellExt: Boolean;
  begin
    Result := DllRegisterServer = S_OK;
  end;

  function UnInstallShellExt: Boolean;
  begin
    Result := DllUnregisterServer = S_OK;
  end;

begin
  try
    if ParamCount = 0 then
    begin
      ShowHelp;
      Exit;
    end;
    case LowerCase(ParamStr(1))[2] of
      'i':
        if InstallShellExt then
          Writeln(Translate('  .'))
        else
          Writeln(Translate('  : ' +
            SysErrorMessage(GetLastError)));
      'u':
        if UnInstallShellExt then
          Writeln(Translate('    .'))
        else
          Writeln(Translate('    : ' +
            SysErrorMessage(GetLastError)));
    else
      ShowHelp;
    end;
  finally
    WaitKeyboardInput('    ...');
  end;
end.
